/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.http.saml;

import java.io.File;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;

public class SamlFilesystemMetadataResolver
extends FilesystemMetadataResolver {
    private static int componentIdCounter = 0;

    public SamlFilesystemMetadataResolver(Settings esSettings, Path configPath) throws ResolverException {
        super(SamlFilesystemMetadataResolver.getMetadataFile(esSettings, configPath));
        this.setId(SamlFilesystemMetadataResolver.class.getName() + "_" + ++componentIdCounter);
        this.setRequireValidMetadata(true);
        BasicParserPool basicParserPool = new BasicParserPool();
        try {
            basicParserPool.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new RuntimeException(e);
        }
        this.setParserPool((ParserPool)basicParserPool);
    }

    protected byte[] fetchMetadata() throws ResolverException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws ResolverException {
                    return SamlFilesystemMetadataResolver.super.fetchMetadata();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof ResolverException) {
                throw (ResolverException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private static File getMetadataFile(Settings settings, Path configPath) {
        String originalPath = settings.get("idp.metadata_file", null);
        if (originalPath == null || originalPath.length() == 0) {
            return null;
        }
        Environment env = new Environment(settings, configPath);
        return env.configFile().resolve(originalPath).toAbsolutePath().toFile();
    }
}

